//
// (c) 2020 wesolutions GmbH
// All rights reserved.
//

import QtQuick 2.12

import wesual.Stage 1.0
import wesual.Ui    1.0

Loader {
    id : icon

    property SizeInfo size  : Size.defaultSize()
    property bool highlight : false
    property int iconSize   : UiIcon.Icon_24x24

    width : iconSize
    height : iconSize

    sourceComponent : {
        if (size.aspectRatio >= 2.5 || size.aspectRatio <= .4) {
            return wide;
        } else {
            return regular;
        }
    }

    Component {
        id : wide

        UiIcon {
            iconName : "screen-ultrawide"
            highlight : icon.highlight
            rotation : icon.size.orientation === SizeInfo.Portrait ? 90 : 0
            iconSize : icon.iconSize
        }
    }

    Component {
        id : regular

        Item {
            Rectangle {
                readonly property size size : {
                    const sz = icon.size.scaledSize(
                                 Qt.size(icon.iconSize - 4,
                                         icon.iconSize - 4));
                    if (icon.size.aspectRatio < 1) {
                        sz.width += sz.width % 2;
                    } else {
                        sz.height += sz.height % 2;
                    }

                    return sz;
                }

                anchors.centerIn : parent
                radius : 1
                border {
                    color : icon.highlight ? "white" : "#777"
                    width : 2
                }
                color : icon.highlight ? "transparent" : "white"
                width : size.width + 4
                height : size.height + 4
            }
        }
    }
}
